// This file was generated by Dashcode from Apple Inc.
// You may edit this file to customize your Dashboard widget.

//Version - must match property
var gVersion = "2.8";

//in prefs
var gLastProfile;  // V2.0
//profile also in prefs
var gProfileSet;  // in each profile
var gLastMeasurement;  // in each profile

var mUnitsChanging;
var mDtCh= "/";
var mMinYear=1900;
var mMaxYear=2020;
var mMaxLblMeas=11;
var mMaxLblMeas2=33;
var mFieldSep = '|';
var mFieldInfoSep = '^';
var mPasswordChar = '•';
var mWaitingForMeasurement;
var mCurrentHeight;
var mMeasDate = '';
var mMeasDateServer = '';

//"constants"
var MAX_PROFILE_INDEX = 3;

//gMeasurementState
var MEASURE_READY =  0x80;  // if bit 7 set, ready for new measurement request
var MEASURE_SEARCHING =  1;
var MEASURE_SOURCE_DETECTED =  2;
var MEASURE_PROFILE_SENT =  3;
var MEASURE_WAITING_FOR_WEIGHT =  4;
var MEASURE_WAITING_FOR_DATA =  5;
var MEASURE_SOURCE_NOT_FOUND =  0x86;
var MEASURE_PROFILE_INVALID =  0x87;
var MEASURE_WEIGHT_ONLY =  0x88;
var MEASURE_WEIGHT_ONLY_PROFILE_BAD =  0x8B;
var MEASURE_SOURCE_TIMED_OUT =  0x89;   // user never stepped on scale, etc.
var MEASURE_COMPLETE =  0x8A;
var MEASURE_COMPLETE_SHOULD_RESET =  0x8C;
var MEASURE_NON_TANITA_DEVICE = 0x90;
var MEASURE_WRONG_MODEL = 0x91;


//esmeasstat - Web Measurement State  
var WEB_MEAS_REQUEST 				= '0';  //browser set requesting measurement
var WEB_MEAS_SENDING_PROFILE 		= '1';  //=sending profile
var WEB_MEAS_PROFILE_SENT 			= '2';  //=profile sent, step on scale
var WEB_MEAS_SOME_MEASUREMENT 		= '3';  //=have some measurement
var WEB_MEAS_MEASUREMENT_EMPTY 		= '7';  //=measurement blank
var WEB_MEAS_MEASUREMENT_COMPLETE 	= '8';  //=done and no more updates
var WEB_MEAS_ERROR 					= '9';  //=error

//
// Function: GetMeasure(event)
// Called when the get measure button pressed.
//
function GetMeasure(event)
{
    var theObj = document.getElementById('lblDiag');
    showStat("Initializing...");  // hides measurement
	
    if (ANTWidgetPlugin)
	{	
        setText(theObj,"...loaded plugin");
        
        getDateStrings();  // set mMeasDate and mMeasDateServer for use now and at end
        
        var theAge = getAge(widget.preferenceForKey('espbirthday' + gLastProfile.toString()));
        theAge = theAge.toString();
        var theGender;
        if(widget.preferenceForKey('espgender1' + gLastProfile.toString()) == true)
            theGender = "0";
        else
            theGender = "1";
        var theLevel;
        if(widget.preferenceForKey('espbtype1' + gLastProfile.toString()) == true)
            theLevel = "0";
        else
            theLevel = "1";
        
        //round height in cm
        var theHeight = widget.preferenceForKey('espheight' + gLastProfile.toString());
        var heightNum = parseFloat(theHeight); 
        heightNum = heightNum.toFixed(0);
        theHeight = heightNum.toString();
        
        var devNum = widget.preferenceForKey('esscalesn' + gLastProfile.toString());
        var theScale = widget.preferenceForKey('esscale' + gLastProfile.toString());
        if((theScale == "BC-1000") || (devNum.length == 0))
            devNum = "1";
        if(theScale == "BF-2000")
            theLevel = "0";  // no athlete for BF-2000
        
        var modNum = getModelNumber(theScale);
        mWaitingForMeasurement = true;
        
		var startResult = ANTWidgetPlugin.startMeasurement(widget.preferenceForKey('espname' + gLastProfile.toString()),widget.preferenceForKey('espid' + gLastProfile.toString()),theGender,
            theAge,theHeight,widget.preferenceForKey('espactlev' + gLastProfile.toString()),
            theLevel,widget.preferenceForKey('espweightonly' + gLastProfile.toString()),devNum,modNum,mMeasDateServer);
        
        if(startResult > 0) {
            showStat("Error. Make sure ANT USB Stick is installed and ANT Agent software is not running.");
            setText(theObj,"...Error " + startResult);
            //theObj.innerText = theObj.innerText + "...Error " + startResult;
            
            //if(gLastMeasurement.length > 0)
            //    showMeas(gLastMeasurement);
            }
        else {
            //showStat("Initializing...");  // hides measurement

            //disable get measure button
            var theElement = document.getElementById("getMeasurement");
            theElement.object.enabled = false;
            }
    }
    else {
        showStat("Error. Plugin not found!");
    }
}

//
// Function: openPrefs()
//  Read any necessary prefs but mainly check that they are up to date.
function openPrefs()
{
    var theVal;
    var theID,i;
    var theFields = 'ProfileSet,LastMeasure,espname,espid,espgender1,espgender2,espbirthday,espunits1,espunits2,espheight,espheightft,espheightin,espactlev,espbtype1,espbtype2,espweightonly,esscale,esscalesn';
    var cookieFields = theFields.split(',');

    theVal = widget.preferenceForKey("PrefVersion");
    if(theVal == null) {
        //see if old prefs exist
        theVal = widget.preferenceForKey("ProfileSet");
        if(theVal != null) {
            //old prefs exist, read and then save in new pref user 1
            for(i=0; i<cookieFields.length; i++) {
                theID = cookieFields[i];
                theVal = widget.preferenceForKey(theID);
                if(theVal != null) {
                    widget.setPreferenceForKey(theVal,theID + "0");  // save for user 1
                    widget.setPreferenceForKey(null,theID);  // delete old pref
                    }
                }

            widget.setPreferenceForKey(0,"LastProfile");
            }
        }
    
    gLastProfile = widget.preferenceForKey("LastProfile");
    if(gLastProfile == null) {
        gLastProfile = 0;
        }

    widget.setPreferenceForKey(gVersion,"PrefVersion");
}
//
// Function: clearPrefs()
//
function clearPrefs()
{
    //V1.0 profile
    var theID,theObj,i,hiddenVal,idValue;
    var theFields = 'espname,espid,espgender1,espgender2,espbirthday,espunits1,espunits2,espheight,espheightft,espheightin,espactlev,espbtype1,espbtype2,espweightonly,esscale,esscalesn';
    var cookieFields = theFields.split(',');
    for(i=0; i<cookieFields.length; i++) {
        theID = cookieFields[i];
        widget.setPreferenceForKey(null,theID);
        }

    //V1.0 other
    widget.setPreferenceForKey(null,"ProfileSet");
    widget.setPreferenceForKey(null,"LastMeasure");

    //V2.0+
    //profile 
    var theID,theObj,i,hiddenVal,idValue,profIndex;
    var theFields = 'espnickname,espname,espid,espgender1,espgender2,espbirthday,espunits1,espunits2,espheight,espheightft,espheightin,espactlev,espbtype1,espbtype2,espweightonly,esscale,esscalesn';
    var cookieFields = theFields.split(',');
    
    for(profIndex=0 ; profIndex<=MAX_PROFILE_INDEX ; profIndex++) {
        for(i=0; i<cookieFields.length; i++) {
            theID = cookieFields[i];
            widget.setPreferenceForKey(null,theID + profIndex.toString());
            }

        //other profile
        widget.setPreferenceForKey(null,"ProfileSet" + profIndex.toString());
        widget.setPreferenceForKey(null,"LastMeasure" + profIndex.toString());
        }

    //other
    widget.setPreferenceForKey(null,"LastProfile");
}
//
// Function: loadProfile()
// Set elements on back based on saved profile.
//
function loadProfile(profNum)
{
    var theVal;
    var theID,theObj,i,j;
    var theFields = 'espnickname,espname,espid,espgender1,espgender2,espbirthday,espunits1,espunits2,espheight,espheightft,espheightin,espactlev,espbtype1,espbtype2,espweightonly,esscale,esscalesn';
	
    var cookieFields = theFields.split(',');
	for(i=0; i<cookieFields.length; i++) {
        theID = cookieFields[i];
        theObj = document.getElementById(theID);
        theVal = widget.preferenceForKey(theID + profNum.toString());
        if(theVal != null) {
            if(theObj.type == "radio")
                theObj.checked = theVal;
            else {
                if(theID != "espid")
                    theObj.value = theVal;
                else {
                    //hide password
                    theObj.value = makeHiddenPassword();  // make hidden password from prefs
                    }
                }
            }
        else {
            if(theID == "espbirthday")
                theObj.value = "1/1/1960";
            else {
                if(theID == "espheight")
                    theObj.value = "167.6";
                else {
                    if(theID == "espheightft")
                            theObj.value = "5";
                    else {
                        if(theID == "espheightin")
                            theObj.value = "6";
                        else
                            if((theID != "esscale") && (theID != "esscalesn"))  // keep previously selected scale, if none will fix below
                                theObj.value = "";
                        }
                    }
                }
            }
        }
    
    theObj = document.getElementById("espnickname");
    if((theObj.value == null) || (theObj.value == "")) {
        var userProfNum = new Number(profNum);
        userProfNum++;
        theObj.value = "User " + userProfNum.toString();
        }
    
    //theObj = document.getElementById("esscalesn");
    //if(theObj.value==null || theObj.value=="") {
    //    theObj.value = "0";
    //    }
    theObj = document.getElementById("esscale");
    //var theScale = widget.preferenceForKey("esscale" + profNum.toString());
    if(theObj.value==null || theObj.value=="") {
        theObj.value = "BC-1000";
        }
    setScale(theObj.value);

    gProfileSet = widget.preferenceForKey("ProfileSet" + profNum.toString());
    if(gProfileSet == null) {
        gProfileSet = false;
        }

    gLastMeasurement = widget.preferenceForKey("LastMeasure" + profNum.toString());
    if(gLastMeasurement == null) {
        gLastMeasurement = "";
        }
}

//
// Function: ShowBack()
// Show widget back
//
function ShowBack(event)
{
    ANTWidgetPlugin.stopMeasurement();

    loadProfile(gLastProfile);

    //show version, may have been hidden
    var theComment = document.getElementById("lblVersion");
    setText(theComment,"V" + gVersion);
    theComment.style.display = "block";

    //hide profile comment, may have been shown
    var theComment = document.getElementById("lblProfileComment");
    setText(theComment,"");
    theComment.style.display = "none";

    //show Tanita, may have been hidden
    var theElement = document.getElementById("imgTanita");
    theElement.style.display = "block";

    var front = document.getElementById("front");
    var back = document.getElementById("back");

    if(back.style.display != "block") {
        if (window.widget) {
            widget.prepareForTransition("ToBack");
        }

        front.style.display = "none";
        back.style.display = "block";

        if (window.widget) {
            setTimeout('widget.performTransition();', 0);
        }
    }
}

//
// Function: profileComment(theComment)
// Show profile comment.
//
function profileComment(theComment)
{
    var theElement = document.getElementById("imgTanita");
    theElement.style.display = "none";
    theElement = document.getElementById("lblVersion");
    theElement.style.display = "none";
    theElement = document.getElementById("lblProfileComment");
    setText(theElement,theComment);
    theElement.style.display = "block";
}

//
// Function: isDate(dtStr)
// Verify string is a date and return age.
//
function isDate(dtStr) {
    if((dtStr == null) || (dtStr == "")) {
        profileComment("You must enter a birthday.");
        return -1;
        }
    else {
        var daysInMonth = daysArray(12);
        var pos1=dtStr.indexOf(mDtCh);
        var pos2=dtStr.indexOf(mDtCh,pos1+1);
        var strMonth=dtStr.substring(0,pos1);
        var strDay=dtStr.substring(pos1+1,pos2);
        var strYear=dtStr.substring(pos2+1);
        strYr=strYear;
        if (strDay.charAt(0)=="0" && strDay.length>1) 
            strDay=strDay.substring(1);
        if (strMonth.charAt(0)=="0" && strMonth.length>1) 
            strMonth=strMonth.substring(1);
        for (var i = 1; i <= 3; i++) {
            if (strYr.charAt(0)=="0" && strYr.length>1) strYr=strYr.substring(1);
            }
        var month=parseInt(strMonth);
        var day=parseInt(strDay);
        var year=parseInt(strYr);
        
        if (pos1==-1 || pos2==-1) {
            profileComment('The date format should be "mm/dd/yyyy".');
            return -1;
            }
        if (strMonth.length<1 || month<1 || month>12) {
            profileComment("Please enter a valid month.");
            return -1;
            }
        if (strDay.length<1 || day<1 || day>31 || (month==2 && day>daysInFebruary(year)) || day > daysInMonth[month]) {
            profileComment("Please enter a valid day.");
            return -1;
            }
        if (strYear.length != 4 || year==0 || year<mMinYear || year>mMaxYear) {
            profileComment("Please enter a valid 4 digit year between "+mMinYear+" and "+mMaxYear+".");
            return -1;
            }
        if (dtStr.indexOf(mDtCh,pos2+1)!=-1 || isInteger(stripCharsInBag(dtStr, mDtCh))==false) {
            profileComment('Please enter a valid date in the form "mm/dd/yyyy".');
            return -1;
            }
        
        var age = getAge(strMonth + mDtCh + strDay + mDtCh + strYear);
        if(age <= 0)
            profileComment("Birthday indicates user is too young.");
        
        return age;
        }
	}

//
// Function: ProfileDone(event)
// Called when the done pressed in profile
//
function ProfileDone(event)
{
	var age;
	var result = true;

	//figure height for units not currently active
	var unitObj = document.getElementById('espunits1');
	if(unitObj != null) {
		if(unitObj.checked == true) {
			//english
			changeUnits(false);
			}
		else {
			//metric
			changeUnits(true);
			}
		
		//now check validity of height fields and birthday
        if(unitObj.checked == true) {
            //english
            with(espheightft) {
                if(value==null || value=="" || value==0) {
                    profileComment("You must enter your height.");
                    espheightft.focus();
                    result = false;
                    }
                }
            with(espheightin) {
                if(value==null || value=="") {
                    }
                else {
                    var aNum = new Number(value);
                    value = aNum.toFixed(1);
                    if(value >= 12) {
                        profileComment("Inches portion of height must be less than 12.");
                        espheightin.focus();
                        result = false;
                        }
                    }
                }
            }
        else {
            //metric
            with(espheight) {
                var aNum = new Number(value);
                value = aNum.toFixed(1);
                if(value==null || value=="" || value==0) {
                    profileComment("You must enter your height.");
                    espheight.focus();
                    result = false;
                    }
                }
            }

        with(espbirthday) {
            age=isDate(value);
            if(age<=0) {
                espbirthday.focus();
                result = false;
                }
            }
        
        with(esscale) {
            var snObj = document.getElementById("esscalesn");
            if((result == true) && (value == "BF-2000") && (document.getElementById("espweightonly").value == 0) && (age >= 18)) {
                //too old to get body composition from this scale
                profileComment("The BF-2000 can only measure Body Compositon if under 18.");
                espbirthday.focus();
                result = false;
                }
            
            if(result == true) {
                if(value != "BC-1000") {
                    if(snObj.value.length == 0) {
                        profileComment("You must enter your scale's serial number.");
                        esscalesn.focus();
                        result = false;
                        }
                    else {
                        if((parseInt(snObj.value) < 2) || (parseInt(snObj.value) > 65536)) {
                            profileComment("Scale's serial number must be between 2 and 65536.");
                            esscalesn.focus();
                            result = false;
                            }
                        }
                    }
                else {
                    //bc-1000
                    snObj.value = "";
                    }
                }

            if((result == true) && (value != "BC-1500plus") && (document.getElementById("espweightonly").value == 3)) {
                //only bf-1500plus can do heart rate
                profileComment("The selected scale can not measure Heart Rate.");
                espweightonly.focus();
                result = false;
                }
            }
        
        with(espnickname) {
            if(value==null || value=="") {
                profileComment("You must enter a nickname.");
                espnickname.focus();
                result = false;
                }
            }
		}
	
	if(result == true) {
        //save profile
        var theID,theObj,i,hiddenVal,idValue;
        var theFields = 'espnickname,espname,espid,espgender1,espgender2,espbirthday,espunits1,espunits2,espheight,espheightft,espheightin,espactlev,espbtype1,espbtype2,espweightonly,esscale,esscalesn';
        var cookieFields = theFields.split(',');
        for(i=0; i<cookieFields.length; i++) {
            theID = cookieFields[i];
            theObj = document.getElementById(theID);
            if(theObj.type == "radio")
                widget.setPreferenceForKey(theObj.checked,theID + gLastProfile.toString());
            else {
                if(theID != "espid")
                    widget.setPreferenceForKey(theObj.value,theID + gLastProfile.toString());
                else {
                    hiddenVal =  makeHiddenPassword();  // make hidden password from prefs;
                    if(hiddenVal != theObj.value)
                        //changed from hidden value
                        widget.setPreferenceForKey(theObj.value,theID + gLastProfile.toString());
                    }
                }
            }

        gProfileSet = true;
        widget.setPreferenceForKey(gProfileSet,"ProfileSet" + gLastProfile.toString());

        widget.setPreferenceForKey(gLastProfile,"LastProfile");

		showFront();
        }
}

//
// Function: showFront()
// Show front.
//
function showFront()
{
    //show measurement if available else tell use to get measurement
    if(gLastMeasurement.length > 0)
        showMeas(gLastMeasurement,true);
    else
        showStat('Click "Get Measurement" to use your scale.');
        
    //make sure get measure button enabled
    var theElement = document.getElementById("getMeasurement");
    theElement.object.enabled = true;

    var front = document.getElementById("front");
    var back = document.getElementById("back");

    if(front.style.display != "block") {
        if (window.widget) {
            widget.prepareForTransition("ToFront");
        }

        front.style.display="block";
        back.style.display="none";

        if (window.widget) {
            setTimeout('widget.performTransition();', 0);
        }
    }
    
    setMyTanitaButtonText();
    
    fillProfileList();
    
    setProfile(gLastProfile);
}

//
// Function: UnitsRadioChange()
// Called by HTML body element when units radio button changes
//
function UnitsRadioChange(event) {
	//see if checked, needed for ie
    if(event.target.checked = true) {
        var radValue = event.target.value;
        var metGood;
        if(radValue == '0') {
            metGood = true;
            }
        else {
            metGood = false;
            }
        changeUnits(metGood);
        }
    }

function OnlyNumbers(e,fieldID,allowChar,maxAllowChar) {
    //OnlyNumbers(e,fieldID,allowChar,maxAllowChar)
    //OnlyNumbers(event,'espbirthday','/',2)
    //OnlyNumbers(event,'espheightft','',0)
    //OnlyNumbers(event,'espheightin','.',1)
    //OnlyNumbers(event,'espheight','',0)
    if(e.currentTarget.name == 'espbirthday') {
        fieldID = 'espbirthday';
        allowChar = '/';
        maxAllowChar = 2;
        }
    else if(e.currentTarget.name == 'espheightft') {
        fieldID = 'espheightft';
        allowChar = '';
        maxAllowChar = 0;
        }
    else if(e.currentTarget.name == 'espheightin') {
        fieldID = 'espheightin';
        allowChar = '.';
        maxAllowChar = 1;
        }
    else if(e.currentTarget.name == 'espheight') {
        fieldID = 'espheight';
        allowChar = '.';
        maxAllowChar = 1;
        }

	var keychar;
	var numcheck;
	
	var keynum=e.charCode? e.charCode : e.keyCode

	keychar = String.fromCharCode(keynum);
	if(keychar== allowChar) {
		//profileComment(keychar);
		var unitObj = document.getElementById(fieldID);
		if(unitObj != null) {
			var fieldArray = unitObj.value.split(allowChar);
			//ShowBack(fieldArray.length + ',' + maxAllowChar);
			if(fieldArray.length < (maxAllowChar+1))
				return keynum;
			}
		return false;
		}
	else {
		if((keynum < 32) ||  (keynum > 127))
			return keynum;
		else {
			numcheck = /\d/;
			return numcheck.test(keychar);
			}
		}
	}

//
// Function: load()
// Called by HTML body element's onload event when the widget is ready to start
//
function load()
{
    setupParts();
    
    //clearPrefs();
    
    openPrefs();
    
    mWaitingForMeasurement = false;
    mUnitsChanging = false;
    
    //hide diag text
    var textDiagValue = document.getElementById("lblDiag");
    setText(textDiagValue,"Diagnostic");
    textDiagValue.style.display = 'none';

    hideMeas(true);  // hide measurement elements

    var theObj = document.getElementById('lblMeasureStat');
    theObj.style.opacity = '0';
    //theObj.style.display = 'none';

    fillProfileList();  // fill list with nicknames

    loadProfile(gLastProfile);

    setProfile(gLastProfile);
    
    handleUnits();  // show/hide proper units fields based on radio button setting
}

//
// Function: show()
// Called when the widget has been shown
//
function show()
{
if(gLastMeasurement.length > 0)
    showMeas(gLastMeasurement,true);  // note fade in fast in case not showing measure before and get measure immediately pressed
else
    showStat('Click "Get Measurement" to use your scale.');
    
if(!gProfileSet) {
    showStat('Click "i" to enter your profile.');
    ShowBack();
    }
else {
    setMyTanitaButtonText()

    var theElement = document.getElementById("getMeasurement");
    theElement.object.enabled = true;
    }
}

//
// Function: remove()
// Called when the widget has been removed from the Dashboard
//
function remove()
{
ANTWidgetPlugin.stopMeasurement();
}

//
// Function: hide()
// Called when the widget has been hidden
//
function hide()
{
ANTWidgetPlugin.stopMeasurement();
}

if (window.widget) {
    widget.onremove = remove;
    widget.onhide = hide;
    widget.onshow = show;
}

//
// d2h(d)
// Decimal to hex.
function d2h(d) {return d.toString(16);}

//
// hideMeas
// Hide measurement elements.
function hideMeas(fast) {
    var anElement;
    anElement = document.getElementById("lblComment");
    anElement.style.display = 'none';
    //anElement = document.getElementById("fraMeasure");
    //anElement.style.display = 'none';
    
    var itemToFadeOut = document.getElementById("fraMeasure");	// replace with name of element to fade
    //var itemToFadeOut2 = document.getElementById("topRectangleShape");	// replace with name of element to fade
    if(fast == true) {
        itemToFadeOut.style.opacity = 0.0;
        //itemToFadeOut2.style.opacity = 0.0;
    }
    else {
        var currentOpacity = itemToFadeOut.style.opacity;
        if(currentOpacity == "") currentOpacity = 1;
        if(currentOpacity > 0) {
            //use animator to fade slowly
            var fadeHandler = function(a, c, s, f){ itemToFadeOut.style.opacity = c; };
            //var fadeHandler = function(a, c, s, f){ itemToFadeOut.style.opacity = c; itemToFadeOut2.style.opacity = c; };
            new AppleAnimator(500, 13, currentOpacity, 0.0, fadeHandler).start();
        }
    }

    var itemToFadeOut = document.getElementById("fraMeasure2");	// replace with name of element to fade
    //var itemToFadeOut2 = document.getElementById("topRectangleShape");	// replace with name of element to fade
    if(fast == true) {
        itemToFadeOut.style.opacity = 0.0;
        //itemToFadeOut2.style.opacity = 0.0;
    }
    else {
        var currentOpacity = itemToFadeOut.style.opacity;
        if(currentOpacity == "") currentOpacity = 1;
        if(currentOpacity > 0) {
            //use animator to fade slowly
            var fadeHandler = function(a, c, s, f){ itemToFadeOut.style.opacity = c; };
            //var fadeHandler = function(a, c, s, f){ itemToFadeOut.style.opacity = c; itemToFadeOut2.style.opacity = c; };
            new AppleAnimator(500, 13, currentOpacity, 0.0, fadeHandler).start();
        }
    }
}

//
// showComment
// Show comment in measurement if any.
function showComment(measurement) {
    var textComment = document.getElementById("lblComment");
    var theComment = showAMeas(measurement,"escomment","","")
    setText(textComment,theComment);
    textComment.style.display = 'block';
}

//
// Function: showStat(theMessage)
// Show status on front.
function showStat(theMessage) {
    hideMeas(true);
    //var theObj = document.getElementById('lblMeasureStat');
    //theObj.innerText = theMessage;
    //theObj.style.display = 'block';
    var itemToFadeIn = document.getElementById("lblMeasureStat");	// replace with name of element to fade
    setText(itemToFadeIn,theMessage);
    //itemToFadeIn.innerText = theMessage;
    var currentOpacity = itemToFadeIn.style.opacity;
    if(currentOpacity == "") currentOpacity = "0";
    var fadeInHandler = function(a, c, s, f){ itemToFadeIn.style.opacity = c; };
    new AppleAnimator(500, 13, currentOpacity, 1.0, fadeInHandler).start();
}

//
// showAMeas(theMeas,theName,unitStr)
// Show a measurement given "measurement", a string of "key;value" separated by ":".
function showAMeas(measurement,theKey,theName,unitStr) {
    if(measurement.length > 2) {
        var keyValStart = measurement.indexOf(theKey);
        
        if(keyValStart >= 0) {
            var valStart = measurement.indexOf(mFieldInfoSep,keyValStart+1) + 1;
            if(valStart >= 0) {
                var valEnd = measurement.indexOf(mFieldSep,valStart+1);
                if(valEnd >= 0) {
                    var theMeas = measurement.substring(valStart,valEnd);
                    if(unitStr != "kg")
                        return theMeas + unitStr;
                        //return theName + ": " + theMeas + unitStr;
                    else {
                        if(widget.preferenceForKey('espunits2' + gLastProfile.toString()) == "1")
                            return theMeas + " kg";
                            //return theName + ": " + theMeas + " kg";
                        else {
                            var measLbs = theMeas * 22.046;
                            measLbs = Math.round(measLbs);
                            if((measLbs % 2) == 1)
                                measLbs = measLbs + 1;
                            measLbs = measLbs / 10;
                            
                            return measLbs + " lb";
                            //return theName + ": " + measLbs + " lb";
                        }
                    }
                }
            }
        }
    }
    return "";
}

//
// showMeas(measurement)
// Show a measurement given "measurement", a string of "key;value" separated by ":".
function showMeas(measurement,fast) {
    var i,itemNum;
    var theVal;
    var textName,textVal,fieldInfo;
    var usingFrame;

    //hide stat
    var theObj = document.getElementById('lblMeasureStat');
    theObj.style.opacity = '0';
    //theObj.style.display = 'none';

    theVal = showAMeas(measurement,'esbfra','esbfra','');  // try to get right arm body fat
    if(theVal.length == 0) {
        usingFrame = "fraMeasure";
        var theFields = "esdate;;:esscale;Scale;:esweight;Weight;kg:esbmi;BMI;:esbodyfat;Body Fat;%:esfatmass;Fat Mass;kg:esfatfreemass;Fat Free Mass;kg:esbodywater;Body Water;%:estbw;Total Body Water;kg:esmusclemass;Muscle Mass;kg:esbonemass;Bone Mass;kg:esdci;DCI; kcal:esbmr;Basal Metabolic Rate; kcal:esmetabolicage;Metabolic Age;:esphysiquerating;Physique Rating;:esvfl;Visceral Fat Level;";
        var fieldArray = theFields.split(':');
        itemNum = 1;
        for(i=0; i<fieldArray.length; i++) {
            fieldInfo = fieldArray[i].split(';');
            if(fieldInfo.length > 2) {
                theVal = showAMeas(measurement,fieldInfo[0],fieldInfo[1],fieldInfo[2]);
                if((itemNum <= mMaxLblMeas) && (theVal.length > 0)) {
                    textName = document.getElementById("lblName" + itemNum.toString());
                    setText(textName,fieldInfo[1]);
                    textVal = document.getElementById("lblVal" + itemNum.toString());
                    setText(textVal,theVal);
                    itemNum = itemNum + 1;
                    }
                }
            }
    
        //blank out remaing fields
        for(; itemNum <= mMaxLblMeas ; itemNum++) {
            textName = document.getElementById("lblName" + itemNum.toString());
            setText(textName,"");
            textVal = document.getElementById("lblVal" + itemNum.toString());
            setText(textVal,"");
            }
        }
    else {
        //there is segmental data, use fraMeasure2 for measurement
        usingFrame = "fraMeasure2";
        var theFields = "esdate;;:esscale;Scale;:esweight;Weight;kg:esbmi;BMI;:esbodyfat;Body Fat;%:esfatmass;Fat Mass;kg:esfatfreemass;Fat Free Mass;kg:esbodywater;Body Water;%:estbw;Total Body Water;kg:esmusclemass;Muscle Mass (MM);kg:esbonemass;Bone Mass;kg:esdci;DCI; kcal:esbmr;Basal Metabolic Rate; kcal:esmetabolicage;Metabolic Age;:esphysiquerating;Physique Rating;:esvfl;Visceral Fat Level;:esheartrate;Heart Rate; bpm";
        var fieldArray = theFields.split(':');
        itemNum = 12;
        for(i=0; i<fieldArray.length; i++) {
            fieldInfo = fieldArray[i].split(';');
            if(fieldInfo.length > 2) {
                theVal = showAMeas(measurement,fieldInfo[0],fieldInfo[1],fieldInfo[2]);
                if((itemNum <= (mMaxLblMeas2-10)) && (theVal.length > 0)) {
                    textName = document.getElementById("lblName" + itemNum.toString());
                    setText(textName,fieldInfo[1]);
                    textVal = document.getElementById("lblVal" + itemNum.toString());
                    setText(textVal,theVal);
                    itemNum = itemNum + 1;
                    }
                }
            }
        
    
        //blank out remaing fields till segments
        for(; itemNum <= (mMaxLblMeas2-10) ; itemNum++) {
            textName = document.getElementById("lblName" + itemNum.toString());
            setText(textName,"");
            textVal = document.getElementById("lblVal" + itemNum.toString());
            setText(textVal,"");
            }

        //now do segments
        var theFields = "esbfla;Fat;%:esmmla;MM;kg:esbfra;Fat;%:esmmra;MM;kg:esbfll;Fat;%:esmmll;MM;kg:esbfrl;Fat;%:esmmrl;MM;kg:esbftr;Fat;%:esmmtr;MM;kg";
        var fieldArray = theFields.split(':');
        itemNum = mMaxLblMeas2 - 9;
        for(i=0; i<fieldArray.length; i++) {
            fieldInfo = fieldArray[i].split(';');
            if(fieldInfo.length > 2) {
                theVal = showAMeas(measurement,fieldInfo[0],fieldInfo[1],fieldInfo[2]);
                if((itemNum <= mMaxLblMeas2) && (theVal.length > 0)) {
                    textName = document.getElementById("lblName" + itemNum.toString());
                    setText(textName,fieldInfo[1]);
                    textVal = document.getElementById("lblVal" + itemNum.toString());
                    setText(textVal,theVal);
                    }
                else {
                    textName = document.getElementById("lblName" + itemNum.toString());
                    setText(textName,"");
                    textVal = document.getElementById("lblVal" + itemNum.toString());
                    setText(textVal,"");
                    }
                itemNum = itemNum + 1;
                }
            }
        }
        
    //get comment separately
    showComment(measurement);
                
    //show the measurement
    //var theMeasurementFrame = document.getElementById("fraMeasure2");
    //theMeasurementFrame.style.display = 'block';
    
    //use animator to fade in slowly
    var itemToFadeIn = document.getElementById(usingFrame);	// replace with name of element to fade
    //var itemToFadeIn2 = document.getElementById("topRectangleShape");	// replace with name of element to fade

    if(fast) {
        itemToFadeIn.style.opacity = 1;
        //itemToFadeIn2.style.opacity = 1;
        }
    else {
        var currentOpacity = itemToFadeIn.style.opacity;
        if(currentOpacity == "") currentOpacity = 0;
        var fadeInHandler = function(a, c, s, f){ itemToFadeIn.style.opacity = c; };
        //var fadeInHandler = function(a, c, s, f){ itemToFadeIn.style.opacity = c; itemToFadeIn.style.opacity = c; };
        new AppleAnimator(500, 13, currentOpacity, 1.0, fadeInHandler).start();
        }
}

//
// DeviceStateChange(value)
// Called by our plugin when device state changes.
function DeviceStateChange(value,rawState,diag,measurement)
{
    measurement = measurement + mFieldSep;  // make sure mFieldSep at end
	
    var textDiagValue = document.getElementById("lblDiag");
    setText(textDiagValue,'MeasState: 0x' + d2h(rawState) + ' WebStat: 0x' + d2h(value) + ' Diag: 0x' + d2h(diag));

    var keyValStart = measurement.indexOf("http");
    if(keyValStart >= 0) {
        setText(textDiagValue,measurement);
        var something = measurement;
    }

	var textStat = document.getElementById("lblMeasureStat");
    var newStat;
    newStat = '';

    var strValue = String.fromCharCode(value);
    if((strValue != "8") && (strValue != "7") && (strValue != "9")){
        if(strValue == "0")
            newStat = newStat + 'Waiting for scale...';
        else if (strValue == "1")
            newStat = newStat + 'Sending profile...';
        else if (strValue == "2") {
            //if scale has handles tell user to lift and step on scale else just step on scale
            var scaleObj = document.getElementById('esscale');
            var woObj = document.getElementById('espweightonly');
            if((scaleObj != null) && (woObj != null))  {
                if((woObj.value != "1") && ((scaleObj.value == "BC-1500plus") || (scaleObj.value == "BC-1500")))
                    newStat = newStat + 'Profile sent.\nLift handles and step on scale.';
                else
                    newStat = newStat + 'Profile sent.\nStep on scale.';
                }
            else
                newStat = newStat + 'Profile sent.\nStep on scale.';
            }
        else if(strValue == "3")
            newStat = newStat + 'Weight received...';
        else
            newStat = newStat + 'Waiting...';
        }
    else {
        //done, either good or bad
        if(strValue == "8") {// have all of the measurement
            if(mWaitingForMeasurement == true) {
                var theDate = new Date();
                measurement = "esdate" + mFieldInfoSep + mMeasDate + mFieldSep + measurement;
                //measurement = "esdate" + mFieldInfoSep + theDate.toLocaleDateString() + " " + theDate.toLocaleTimeString() + mFieldSep + measurement;  // add current date/time
                showMeas(measurement,false);
                gLastMeasurement = measurement;
                widget.setPreferenceForKey(gLastMeasurement,"LastMeasure" + gLastProfile.toString());  // save measurement in prefs
                }
            }
        else if(strValue == "7")
            newStat = newStat + 'No measurement found.';
        else if(strValue == "9") {
            switch(rawState) {
                case MEASURE_SOURCE_NOT_FOUND:
                    newStat = newStat + 'Scale not found.';
                    break;
                case MEASURE_NON_TANITA_DEVICE:
                case MEASURE_WRONG_MODEL:
                    newStat = newStat + 'Error';
                    break;
                default:
                    newStat = newStat + 'Timeout waiting for measurement.';
                }
            
            showComment(measurement);
            }
        
        mWaitingForMeasurement = false;
        
        //enable get measure button
        var theElement = document.getElementById("getMeasurement");
        theElement.object.enabled = true;
        }

	setText(textStat,newStat);
}

function handleUnits() {
	//set up interface based on units
    var anObje1 = document.getElementById('espheightft');
    var anObje2 = document.getElementById('espheightin');
    var anObje3 = document.getElementById('unitft');
    var anObje4 = document.getElementById('unitin');
    var anObjm1 = document.getElementById('espheight');
    var anObjm2 = document.getElementById('unitcm');

    //see if english is currently selected
    var unitObj = document.getElementById('espunits1');
    if(unitObj != null) {
        if(unitObj.checked == true) {
            //english
            anObje1.style.display = 'block';
            anObje2.style.display = 'block';
            anObje3.style.display = 'block';
            anObje4.style.display = 'block';
            anObjm1.style.display = 'none';
            anObjm2.style.display = 'none';
            }
        else {
            //metric
            anObjm1.style.display = 'block';
            anObjm2.style.display = 'block';
            anObje1.style.display = 'none';
            anObje2.style.display = 'none';
            anObje3.style.display = 'none';
            anObje4.style.display = 'none';
            }
        }
	}

function changeUnits(metGood) {
	if(mUnitsChanging == false) {
		mUnitsChanging = true;

		var ftObj = document.getElementById('espheightft');
		if(ftObj != null) {
			var inObj = document.getElementById('espheightin');
			if(inObj != null) {
				var cmObj = document.getElementById('espheight');
				if(cmObj != null) {
					if(metGood == true) {
						//read metric and calc english
						var theInches = 0;
						var cmStr = cmObj.value;
						if(cmStr.length > 0)
							theInches = cmObj.value * 0.3937;
						var theFt = Math.floor(theInches / 12);
						ftObj.value = theFt;
						theInches = theInches - (theFt * 12);
						inObj.value = theInches.toFixed(1);
						}
					else {
						//read ft & in and calce metric
						var theCm = 0;
						var ftStr = inObj.value;
						if(ftStr.length > 0)
							theCm = parseFloat(ftStr);
						ftStr = ftObj.value;
						if(ftStr.length > 0)
							theCm = theCm + parseInt(ftObj.value * 12);
						theCm = theCm * 2.54
						cmObj.value = theCm.toFixed(1);
						}
					handleUnits();
					}
				}
			}

		mUnitsChanging = false;
		}
	}

function getAge(validDateStr) {
	var dateFields = validDateStr.split(mDtCh);
	var month=parseInt(dateFields[0]);
	var day=parseInt(dateFields[1]);
	var year=parseInt(dateFields[2]);

	var today = new Date();
	var age;

	if(((today.getMonth()+1) > month) || (((today.getMonth()+1) == month) && (today.getDate() >= day)))
		age=today.getFullYear() - year;
	else
		age=today.getFullYear() - year - 1;

	return age;
	}

function daysInFebruary(year) {
	// February has 29 days in any year evenly divisible by four,
    // EXCEPT for centurial years which are not also divisible by 400.
    return (((year % 4 == 0) && ( (!(year % 100 == 0)) || (year % 400 == 0))) ? 29 : 28 );
	}

function daysArray(n) {
	for (var i = 1; i <= n; i++) {
		this[i] = 31;
		if (i==4 || i==6 || i==9 || i==11)
			this[i] = 30;
		if (i==2) 
			this[i] = 29;
   		}
   	return this;
	}

function isInteger(s) {
	var patt=/\D/;
	return !patt.test(s);
	}

function stripCharsInBag(s, bag) {
	var i;
    var returnString = "";
    // Search through string's characters one by one.
    // If character is not in bag, append to returnString.
    for (i = 0; i < s.length; i++) {   
        var c = s.charAt(i);
        if (bag.indexOf(c) == -1) returnString += c;
    	}
    return returnString;
	}

function getDateStrings() {
    //measurement = "esdate" + mFieldInfoSep + theDate.toLocaleDateString() + " " + theDate.toLocaleTimeString() + mFieldSep + measurement  // add current date/time
    var a_p = "";
    var theDate = new Date();
    var longTime = theDate.toLocaleTimeString();
    var finalTime = longTime;

    var valEnd = longTime.indexOf(":");
    if(valEnd >= 0) {
        valEnd = longTime.indexOf(":",valEnd+1);
        if(valEnd >= 2) {
            //ok, there are two ":" so I know what to do with this
            var curr_hour = theDate.getHours();

            if (curr_hour < 12)
               {
               a_p = " AM";
               }
            else
               {
               a_p = " PM";
               }
            
            finalTime = longTime.substring(0,valEnd) + a_p;
            }
        }
    mMeasDate = theDate.toLocaleDateString() + " " + finalTime;  // this is time that will be saved in measurement
    //return (theDate.toLocaleDateString() + " " + finalTime);
    
    //server time format is "yyyy-MM-dd HH:mm:SS"
    mMeasDateServer = theDate.getFullYear() + "-" + (theDate.getMonth()+1) + "-" + theDate.getDate() + " " + theDate.getHours() + ":" + theDate.getMinutes() + ":" + theDate.getSeconds();
}

function setText(theObj,value)
{
    //apparently should use textContent but does not always work
    var hasInnerText = (theObj.innerText != undefined) ? true : false;
    if(!hasInnerText){
        theObj.textContent = value;
    } 
    else{
        theObj.innerText = value;
    }
}

function makeHiddenPassword()
{
    //make hidden password from prefs
    var userid = widget.preferenceForKey('espid' + gLastProfile.toString());
    if(userid == null) userid = "";
    var hiddenVal = "";
    for(j=0 ; j<userid.length ; j++)
        hiddenVal = hiddenVal + mPasswordChar;
        
    return(hiddenVal);
}

function OpenWebSite(event)
{
    //auto log into my.tanita if username and password, else just go to my.tanita
    var username = "";
    var userid = ""
	var theObj = document.getElementById('espname');
	if(theObj != null)
        var username = theObj.value;

	theObj = document.getElementById('espid');
	if(theObj != null) {
        //id could be hidden if not just changed
        userid = widget.preferenceForKey('espid' + gLastProfile.toString());
        if(userid == null) userid = "";
        
        var hiddenVal = makeHiddenPassword();  // make hidden password from prefs
        
        if(hiddenVal != theObj.value)
            //changed from prefs value
            userid = theObj.value;
        }
    
    openMyTanita(username,userid);
}


function MyTanitaClick(event)
{
    //auto log into my.tanita if username and password, else just go to my.tanita
    var username = widget.preferenceForKey('espname' + gLastProfile.toString());
    if(username == null) username = "";
    var userid = widget.preferenceForKey('espid' + gLastProfile.toString());
    if(userid == null) username = "";
    
    openMyTanita(username,userid);
}

function openMyTanita(username,userid)
{
    if ((username.length > 0) && (userid.length > 0))
        widget.openURL("https://my.tanita.com/login/?71[loginName]=" + username + "&71[loginPassword]=" + userid + "&login=1");
    else
        widget.openURL("http://my.tanita.com/");
}

function setMyTanitaButtonText()
{
    var theObj;
    var username = widget.preferenceForKey('espname' + gLastProfile.toString());
    if(username == null) username = "";
    var userid = widget.preferenceForKey('espid' + gLastProfile.toString());
    if(userid == null) userid = "";
    if ((userid.length > 0) && (username.length > 0)) {
        //setText(theObj,"View History");
        theObj = document.getElementById('btnMyTanitaLogin');
        if(theObj != null)
            theObj.style.display = "block";
        theObj = document.getElementById('btnMyTanita');
        if(theObj != null)
            theObj.style.display = "none";
        }
    else {
        //setText(theObj,"My.Tanita");
        theObj = document.getElementById('btnMyTanitaLogin');
        if(theObj != null)
            theObj.style.display = "none";
        theObj = document.getElementById('btnMyTanita');
        if(theObj != null)
            theObj.style.display = "block";
        }
}

function ScaleChanged(event)
{
    var theObj = document.getElementById('esscale');
    if(theObj != null) {
        setScale(theObj.value);

        
        //select with heart rate when BC-1500plus selected
        if(theObj.value == "BC-1500plus") {
            woObj = document.getElementById('espweightonly');
            if(woObj != null) {
                if(woObj.value == "0")  // change to body composition plus heart rate if set to body composition
                    woObj.value = "3";
                }
            }
        }
}

function setScale(theScale)
{
    var theObj = document.getElementById('esscale');
    if(theObj != null) {
        //hide serial number of BC-1000
        var snObj = document.getElementById('esscalesn');
        var theSNlbl = document.getElementById('lblsn');
        if((snObj != null) && (theSNlbl != null)) {
            if(theObj.value != theScale)
                theObj.value = theScale;
                
            if(theScale != "BC-1000") {
                snObj.style.display = "block";
                theSNlbl.style.display = "block";
                //snObj.disabled = false;
                }
            else {
                snObj.style.display = "none";
                theSNlbl.style.display = "none";
                //snObj.disabled = true;
                }
            }
        
        //hide body type of BF-2000
        snObj = document.getElementById('espbtype1');
        theSNlbl = document.getElementById('espbtype2');
        if((snObj != null) && (theSNlbl != null)) {
            if(theObj.value != theScale)
                theObj.value = theScale;
                
            if(theScale == "BF-2000") {
                snObj.disabled = true;
                theSNlbl.disabled = true;
                }
            else {
                snObj.disabled = false;
                theSNlbl.disabled = false;
                }
            }
        }
}

//
// Function: ProfileSelectionChanged()
//  Event handler for cmbProfile.
function ProfileSelectionChanged(event)
{
    var theObj = document.getElementById('cmbProfile');
    if(theObj != null) {
        var theVal = theObj.object.getSelectedIndex();
        if(gLastProfile != theVal.toString()) {
            gLastProfile = theVal.toString();

            setProfile(gLastProfile);
            
            loadProfile(gLastProfile);

            if(gProfileSet)
                widget.setPreferenceForKey(gLastProfile,"LastProfile");  // don't do till "done" if profile not good so not stuck with gLastProfile set to incomplete profile
        
            hideMeas(true);
            
            show();
            }
        }
}
//
// Function: setProfile()
//  Select profile in cmbProfile and load it.
function setProfile(theProfile)
{
    var theObj = document.getElementById('cmbProfile');
    if(theObj != null) {
        theObj.object.setSelectedIndex(theProfile);
        }
}
//
// Function: fillProfileList()
//  Fill cmbProfile.
function fillProfileList()
{
    var theVal,profIndex;
    var popup = document.getElementById('cmbProfile');
    if(popup != null) {

        var newPopupOptions = new Array();  // = [["Label1","Value1"],["Label2","Value2"]];	// an array of arrays that contain labels and values

        //now add using nicknames
        for(profIndex=0 ; profIndex<=MAX_PROFILE_INDEX ; profIndex++) {
            theVal = widget.preferenceForKey("espnickname" + profIndex.toString());
            if((theVal == null) || (theVal == "")) {
                theVal = "User " + (profIndex+1).toString();
                }

            var theItem = [theVal,profIndex]
            newPopupOptions.push(theItem);
            }
            
        popup.object.setOptions(newPopupOptions);
        }
}

//
// Function: getModelNumber()
//  Given name, return model number.
function getModelNumber(theModel)
{
    var returnVal;
    
    switch(theModel) {
        case "BC-1500plus":
            returnVal = "18";
            break;
        case "BC-1500":
            returnVal = "6";
            break;
        case "BC-1000plus":
            returnVal = "17";
            break;
        case "BC-1000":
            returnVal = "0";
            break;
        case "BC-1100F":
            returnVal = "3";
            break;
        case "BF-2000":
            returnVal = "4";
            break;
        case "HD-400F":
            returnVal = "16";
            break;
        case "HD-351ANT":
            returnVal = "5";
            break;
        default:
            returnVal = "2048";  // any scale
        }
    return(returnVal);
}









